import os

def txt_to_html():
    script_dir = os.path.dirname(os.path.abspath(__file__))  
    html_file = os.path.join(script_dir, "directory.html")

    section_color = "#2a7fc2"
    content_color = "#888888"
    box_width = "400px"  # Adjusted width
    box_height = "70px"  # Slightly taller for two lines of text
    flex_wrap = "wrap"
    font_size = "14px"  # Uniform and slightly smaller

    html_structure = ["<div class='container'>"]

    for filename in os.listdir(script_dir):
        if filename.endswith(".txt"):
            txt_path = os.path.join(script_dir, filename)
            file_content = []
            
            try:
                with open(txt_path, "r", encoding="utf-8", errors="replace") as file:
                    for line in file.readlines():
                        stripped = line.strip()
                        if stripped and "(\\)" not in stripped:
                            if "." not in stripped:
                                file_content.append(f"<div class='section'>{stripped}</div>")
                            else:
                                file_content.append(f"<div class='content'>{stripped}</div>")
            except Exception as e:
                print(f"Error reading {filename}: {e}")

            html_structure.append(f"<div class='column'><h2>{filename}</h2>{''.join(file_content)}</div>")

    html_structure.append("</div>")

    with open(html_file, "w", encoding="utf-8") as file:
        file.write(f"""
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>Styled Directory</title>
            <style>
                body {{ font-family: Arial, sans-serif; margin: 40px; background: #f4f4f4; display: flex; justify-content: center; }}
                .container {{ display: flex; flex-wrap: {flex_wrap}; justify-content: center; gap: 20px; }}
                .column {{ display: flex; flex-direction: column; align-items: center; }}
                h2 {{ text-align: center; color: #333; }}
                .section, .content {{
                    width: {box_width};
                    height: {box_height};
                    font-size: {font_size};
                    text-align: center;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    border-radius: 5px;
                    margin: 5px;
                    transition: all 0.3s ease-in-out;
                    white-space: normal;  /* Allows text to wrap to two lines */
                    overflow: hidden;
                }}
                .section {{ background: {section_color}; color: white; font-weight: bold; }}
                .content {{ background: {content_color}; color: white; }}
                .section:hover, .content:hover {{ box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.3); transform: scale(1.05); }}
            </style>
        </head>
        <body>
        {"".join(html_structure)}
        </body>
        </html>
        """)

    print(f"Finished! HTML saved as {html_file}")

txt_to_html()